package com.intentsoftware.addapptr

enum class BannerSize(val configName: String, val width: Int, val height: Int) {
    Banner320x53("320x53", 320, 53),
    Banner320x50("320x53", 320, 50),
    Banner768x90("768x90", 768, 90),
    Banner300x250("300x250", 300, 250),
    Banner468x60("468x60", 468, 60),
    MultipleSizes("Multiple-Sizes", 0, 0),
    Banner320x75("320x75", 320, 75),
    Banner320x100("320x100", 320, 100),
    Banner320x150("320x150", 320, 150),
    Banner320x160("320x160", 320, 160),
    Banner320x480("320x480", 320, 480);

    companion object {
        internal fun fromServerConfigName(name: String?): BannerSize? {
            if (name == null || name.isEmpty()) {
                return null
            }
            for (n in values()) {
                if (n.configName == name) {
                    return n
                }
            }
            return null
        }
    }
}