package com.intentsoftware.addapptr

/**
 * Allows to pass network-specific configurations to AATKit.
 */
class AATKitAdNetworkOptions(
    var appNexusOptions: AppNexusOptions? = null,
    var feedAdOptions: FeedAdOptions? = null,
    var pubNativeOptions: PubNativeOptions? = null,
    var adMobOptions: AdMobOptions? = null,
    var dfpOptions: DFPOptions? = null
)

/**
 * PubNative specific configurations
 */
class PubNativeOptions(
    /**
     * Minimum offset in seconds required before skipping an HTML Interstitial ad. Null by default.
     */
    var skipOffsetForHTMLInterstitial: Int? = null,

    /**
     * Minimum offset in seconds required before skipping an Video Interstitial ad. Null by default.
     */
    var skipOffsetForVideoInterstitial: Int? = null
)

/**
 * FeedAd specific configurations
 */
class FeedAdOptions(
    /**
     * Desired color-int (as obtained from [android.graphics.Color.parseColor]) to be used for shutter. Default is null.
     */
    var shutterColor: Int? = null,

    /**
     * Boolean that describes if spinner should be disabled, default is false.
     */
    var disableSpinner: Boolean = false
)

/**
 * AppNexus specific configuration
 */
class AppNexusOptions (
    /**
     * A delay in seconds after which  a full-screen ad will be dismissed. Default value is null.
     */
    var autoCloseTime: Int? = null,

    /**
     * A Boolean that describes if Banner Ad can serve a Native Ad, default is false.
     */
    var supportNativeBanner: Boolean = false,

    /**
     * A Boolean that describes if Banner Ad can serve Video Ads, default is false.
     */
    var supportVideoBanner: Boolean = false
)

/**
 * AdMob specific configuration
 */
class AdMobOptions (
    /**
     * Maximum height for AdMob inline adaptive banners
     */
    var inlineBannerMaxHeight: Int?
)

/**
 * DFP specific configuration
 */
class DFPOptions (
    /**
     * Maximum height for DFP inline adaptive banners
     */
    var inlineBannerMaxHeight: Int?
)