package com.intentsoftware.addapptr

import android.util.Log
import com.intentsoftware.addapptr.internal.AdCollapsableBannerLoader
import com.intentsoftware.addapptr.internal.module.Logger.e
import com.intentsoftware.addapptr.internal.module.Logger.isLoggable

/**
 * The request for new banner ad.
 */
class BannerRequest
/**
 * Constructs a new banner request.
 * @param delegate Optional [BannerRequestDelegate]. Can be null.
 */(
    /**
     * Returns the [BannerRequestDelegate] set for this request.
     * @return The [BannerRequestDelegate] if any is set for this request, null otherwise.
     */
    val delegate: BannerRequestDelegate?
) {
    private var bannerSizes: Set<BannerSize>? = null

    /**
     * The targeting information for this request.
     */
    var targetingInformation: Map<String, List<String>>? = null

    /**
     * The content targeting url for this request
     */
    var contentTargetingUrl: String? = null
    private var wasUtilized = false
    internal var isCancelled = false
    internal var completionListener: BannerRequestCompletionListener? = null
    internal var collapsibleBannerLoaderDelegate: AdCollapsableBannerLoader? = null

    /**
     * Returns the set of allowed [BannerSize] for this request.
     * @return The set of banner sizes that can be loaded by this request.
     */
    fun getBannerSizes(): Set<BannerSize>? {
        return bannerSizes
    }

    /**
     * Sets the set of [BannerSize] that can be returned by this request.
     * @param bannerSizes The set of banner sizes that can be loaded by this request.
     */
    fun setBannerSizes(bannerSizes: Set<BannerSize>?) {
        this.bannerSizes = bannerSizes
        if (bannerSizes != null && bannerSizes.isEmpty()) {
            if (isLoggable(Log.ERROR)) {
                e(this, "Passed empty set of allowed banner sizes. No ad will be loaded for this request!")
            }
        }
    }

    internal fun wasUtilized(): Boolean {
        return wasUtilized
    }

    internal fun setWasUtilized(wasUtilized: Boolean) {
        this.wasUtilized = wasUtilized
    }

    override fun toString(): String {
        return "BannerRequest{" +
                "bannerSizes=" + bannerSizes +
                ", delegate=" + delegate +
                ", targetingInformation=" + targetingInformation +
                ", contentTargetingUrl=" + contentTargetingUrl +
                ", @" + Integer.toHexString(hashCode()) + '}'
    }
}