package com.intentsoftware.addapptr.consent

import android.app.Activity
import android.app.Application
import android.util.Log
import com.intentsoftware.addapptr.AdNetwork
import com.intentsoftware.addapptr.ManagedConsent.ManagedConsentState
import com.intentsoftware.addapptr.NonIABConsent
import com.intentsoftware.addapptr.internal.CMPImplementation
import com.intentsoftware.addapptr.internal.ad.networkhelpers.OguryHelper
import com.intentsoftware.addapptr.internal.module.Logger
import com.ogury.cm.OguryChoiceManager
import com.ogury.cm.OguryChoiceManager.Answer
import com.ogury.cm.OguryConsentListener
import com.ogury.core.OguryError

/**
 * Wrapper for Ogury CMP.
 * **Ogury CMP is deprecated and will be removed in AATKit 3.5.**
 *
 * @param application the Application context.
 * @param assetKey    the Asset key of your application.
 */
@Deprecated("Ogury CMP is deprecated and will no longer be supported from AATKit SDK v3.5")
class CMPOgury(application: Application, assetKey: String) : CMPImplementation() {
    private var delegate: CMPDelegate? = null
    private var asked = false
    private var oguryListener: OguryConsentListener? = null
    private var initializationError: String? = null
    public override fun showIfNeeded(activity: Activity) {
        OguryChoiceManager.ask(activity, oguryListener)
        asked = true
    }

    public override fun editConsent(activity: Activity) {
        OguryChoiceManager.edit(activity, oguryListener)
    }

    public override fun setDelegate(delegate: CMPDelegate) {
        this.delegate = delegate
        initializationError?.let {
            delegate.onCMPFailedToLoad(it)
            initializationError = null
        }
    }

    // see https://consent-form.ogury.co/unifiedVendors-tcf-v2/latest/unifiedVendors.json for partners list
    public override fun getConsentForNetwork(network: AdNetwork): NonIABConsent {
        return if (!asked) {
            NonIABConsent.WITHHELD //handle checks before CMP is asked for consent status
        } else when (network) {
            AdNetwork.ADCOLONY -> getCosentForVendorId(524)
            AdNetwork.APPLOVIN, AdNetwork.APPLOVINMAX -> getCosentForVendorId(5)
            AdNetwork.FACEBOOK -> getCosentForVendorId(9)
            AdNetwork.ADMOB, AdNetwork.RTB2, AdNetwork.DFP, AdNetwork.DFPDIRECT -> getCosentForVendorId(459)
            AdNetwork.INMOBI -> getCosentForVendorId(297)
            AdNetwork.IRONSOURCE -> getCosentForVendorId(11)
            AdNetwork.SMAATO -> getCosentForVendorId(248)
            AdNetwork.SMARTAD, AdNetwork.SMARTADSERVERDIRECT -> getCosentForVendorId(34)
            AdNetwork.UNITY -> getCosentForVendorId(16)
            AdNetwork.PUBNATIVE -> getCosentForVendorId(140)
            AdNetwork.TEADS -> getCosentForVendorId(308)
            AdNetwork.HUAWEI -> getCosentForVendorId(588)
            AdNetwork.YOC -> getCosentForVendorId(337)
            AdNetwork.VUNGLE2 -> getCosentForVendorId(17)
            AdNetwork.BLUESTACK -> getCosentForVendorId(69)
            AdNetwork.MINTEGRAL -> getCosentForVendorId(606)
            else -> {
                if (Logger.isLoggable(Log.WARN)) {
                    Logger.w(
                        this,
                        "No mapping for network $network available, treating consent as withheld"
                    )
                }
                NonIABConsent.WITHHELD
            }
        }
    }

    private fun getCosentForVendorId(vendorId: Int): NonIABConsent {
        return if (OguryChoiceManager.TcfV2.isAccepted(vendorId)) NonIABConsent.OBTAINED else NonIABConsent.WITHHELD
    }

    public override fun reload(activity: Activity) {}

    init {
        if (checkRequiredClasses(
                "com.ogury.sdk.Ogury",
                "com.ogury.cm.OguryChoiceManager",
                "com.ogury.cm.OguryConsentListener",
                "com.ogury.core.OguryError"
            )
        ) {
            if (OguryHelper.initOgurySDK(application, assetKey)) {
                oguryListener = object : OguryConsentListener {
                    override fun onComplete(answer: Answer) {
                        if (delegate != null) {
                            val state: ManagedConsentState = when (answer) {
                                Answer.FULL_APPROVAL -> ManagedConsentState.OBTAINED
                                Answer.PARTIAL_APPROVAL -> ManagedConsentState.CUSTOM
                                Answer.REFUSAL -> ManagedConsentState.WITHHELD
                                else -> ManagedConsentState.UNKNOWN
                            }
                            delegate!!.onConsentUpdated(state)
                        }
                    }

                    override fun onError(oguryError: OguryError) {
                        delegate?.onCMPFailedToShow(oguryError.message!!)
                    }
                }
                onSuccessfulInitialization()
            } else {
                val error = "Failed to initialise Ogury SDK"
                if (delegate != null) {
                    delegate!!.onCMPFailedToLoad(error)
                } else {
                    initializationError = error
                }
                if (Logger.isLoggable(Log.ERROR)) {
                    Logger.e(this, error)
                }
            }
        }
    }
}