package com.intentsoftware.addapptr

/**
 * AATKit rule mediation type
 */
enum class MediationType(private val configString: String) {
    WATERFALL("1"), AUCTION("2"), MAYO("3");

    companion object {
        internal fun fromServerConfigString(configString: String?): MediationType? {
            if (configString == null || configString.isEmpty()) {
                return null
            }
            for (n in values()) {
                if (n.configString == configString) {
                    return n
                }
            }
            return null
        }
    }
}