package com.intentsoftware.addapptr;

import androidx.annotation.NonNull;

/**
 * Object describing a reward earned by a user for interacting with a Rewarded Video ad.
 */
public class AATKitReward {

    private final String name;
    private final String value;

    public AATKitReward(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Returns the name of the reward.
     * @return Name of the reward
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the value of the reward.
     * @return Value of the reward
     */
    public String getValue() {
        return value;
    }

    @NonNull
    @Override
    public String toString() {
        return "AATKitReward{" +
                "name='" + name + '\'' +
                ", value='" + value + '\'' +
                '}';
    }
}
