package com.intentsoftware.addapptr;

import androidx.annotation.NonNull;

/**
 * Allows to change settings for AATKit at runtime.
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class AATKitRuntimeConfiguration {

    private static AATKitRuntimeConfiguration oldConfiguration;
    private boolean consentRequired = true;
    private AATKit.Consent consent;

    private boolean useGeoLocation = false;

    /**
     * Creates the AATKitRuntimeConfiguration object to be used when reconfiguring AATKit.
     * It will be automatically initialized with previously used values.
     */
    public AATKitRuntimeConfiguration() {
        if (oldConfiguration != null) {
            this.consentRequired = oldConfiguration.consentRequired;
            this.consent = oldConfiguration.consent;
            this.useGeoLocation = oldConfiguration.useGeoLocation;
        }

        oldConfiguration = this;
    }

    @NonNull
    @Override
    public String toString() {
        return "AATKitRuntimeConfiguration{" +
                "consentRequired=" + consentRequired +
                ", consent=" + consent +
                ", useGeoLocation=" + useGeoLocation +
                '}';
    }

    /**
     * Sets if the GDPR consent is required (if the user falls under GDPR jurisdiction). True by default.
     *
     * @param consentRequired True if user falls under GDPR jurisdiction, false otherwise.
     */
    public void setConsentRequired(boolean consentRequired) {
        this.consentRequired = consentRequired;
    }

    boolean isConsentRequired() {
        return consentRequired;
    }

    /**
     * Sets if geo data (if it is available) should be sent. Disabled by default.
     * @param useGeoLocation True to enable, false to disable
     */
    public void setUseGeoLocation(boolean useGeoLocation) {
        this.useGeoLocation = useGeoLocation;
    }

    boolean isUseGeoLocation() {
        return useGeoLocation;
    }

    /**
     * Sets the detailed consent for GDPR.
     * @param consent Instance of {@link AATKit.Consent} to be used.
     */
    public void setConsent(AATKit.Consent consent) {
        this.consent = consent;
    }

    AATKit.Consent getConsent() {
        return consent;
    }
}
