package com.intentsoftware.addapptr;

import android.util.Log;

import androidx.annotation.NonNull;

import com.intentsoftware.addapptr.module.Logger;

/**
 * The configuration object to be used when creating a banner placement.
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class BannerConfiguration {

    private int numberOfWorkers = 3;
    private boolean manualAdSpaceCounting = false;

    /**
     * Constructs new BannerConfguration to be used when creating new {@link BannerPlacement}.
     */
    public BannerConfiguration() {
    }

    BannerConfiguration(BannerConfiguration configuration) {
        this.numberOfWorkers = configuration.numberOfWorkers;
        this.manualAdSpaceCounting = configuration.manualAdSpaceCounting;
    }

    /**
     * Checks if manual adspace counting is enabled.
     *
     * @return Boolean indicating if manual adspace counting is enabled.
     */
    public boolean isManualAdSpaceCounting() {
        return manualAdSpaceCounting;
    }

    /**
     * Allows to set if manual adspace counting should be used. If manual adspace counting is disabled, adspace is counted on every banner request.
     *
     * @param manualAdSpaceCounting Boolean indicating if manual adspace counting should be enabled.
     */
    public void setManualAdSpaceCounting(boolean manualAdSpaceCounting) {
        this.manualAdSpaceCounting = manualAdSpaceCounting;
    }

    /**
     * Returns the number of ad requests that can be made simultaneously.
     *
     * @return The number of ad requests that can be made simultaneously.
     */
    public int getNumberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * Sets the number of ad requests that can be made simultaneously.
     *
     * @param numberOfWorkers The number of ad requests that can be made simultaneously. Must be greater than 0.
     */
    public void setNumberOfWorkers(int numberOfWorkers) {
        if (numberOfWorkers > 0) {
            this.numberOfWorkers = numberOfWorkers;
        } else {
            if (Logger.isLoggable(Log.ERROR)) {
                Logger.e(AATKit.class, "Number of workers must be greater than 0.");
            }
        }
    }

    @NonNull
    @Override
    public String toString() {
        return "BannerConfiguration{" +
                "numberOfWorkers=" + numberOfWorkers +
                ", manualAdSpaceCounting=" + manualAdSpaceCounting +
                ", @" + Integer.toHexString(hashCode()) + '}';
    }
}
