package com.intentsoftware.addapptr;

/**
 * Placement used for obtaining banner ads.
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public interface BannerPlacement {

    /**
     * Requests a new banner ad.
     * @param request {@link BannerRequest} instance. Can not be null.
     * @param listener {@link BannerRequestCompletionListener} instance that will be called when the request finishes. Can not be null.
     */
    void requestAd(BannerRequest request, BannerRequestCompletionListener listener);

    /**
     * Cancels the given banner request.
     * @param request Request that should be canceled.
     */
    void cancel(BannerRequest request);

    /**
     * Counts the adspace for statistics. Can only be called if manual adspace counting is used.
     * @see BannerConfiguration#setManualAdSpaceCounting(boolean)
     */
    void countAdSpace();
}
