package com.intentsoftware.addapptr;

import android.util.Log;

import com.intentsoftware.addapptr.module.Logger;

import java.util.List;
import java.util.Map;
import java.util.Set;

import androidx.annotation.NonNull;

/**
 * The request for new banner ad.
 */
@SuppressWarnings({"WeakerAccess", "unused", "SameParameterValue"})
public class BannerRequest {

    private Set<BannerSize> bannerSizes;
    private BannerRequestDelegate delegate;
    private Map<String, List<String>> targetingInformation;

    private String contentTargetingUrl;

    private boolean wasUtilized;
    private boolean cancelled;
    private BannerRequestCompletionListener completionListener;

    /**
     * Constructs a new banner request.
     * @param delegate Optional {@link BannerRequestDelegate}. Can be null.
     */
    public BannerRequest(BannerRequestDelegate delegate) {
        this.delegate = delegate;
    }

    /**
     * Returns the set of allowed {@link BannerSize} for this request.
     * @return The set of banner sizes that can be loaded by this request.
     */
    public Set<BannerSize> getBannerSizes() {
        return bannerSizes;
    }

    /**
     * Sets the set of {@link BannerSize} that can be returned by this request.
     * @param bannerSizes The set of banner sizes that can be loaded by this request.
     */
    public void setBannerSizes(Set<BannerSize> bannerSizes) {
        this.bannerSizes = bannerSizes;
        if (bannerSizes != null && bannerSizes.isEmpty()) {
            if(Logger.isLoggable(Log.ERROR)) {
                Logger.e(this, "Passed empty set of allowed banner sizes. No ad will be loaded for this request!");
            }
        }
    }

    /**
     * Returns the {@link BannerRequestDelegate} set for this request.
     * @return The {@link BannerRequestDelegate} if any is set for this request, null otherwise.
     */
    public BannerRequestDelegate getDelegate() {
        return delegate;
    }

    /**
     * Returns the targeting information for this request.
     * @return Map with targeting information or null if no targetting information is set.
     */
    public Map<String, List<String>> getTargetingInformation() {
        return targetingInformation;
    }

    /**
     * Sets the targeting information for this request.
     * @param targetingInformation Map with targeting information
     */
    public void setTargetingInformation(Map<String, List<String>> targetingInformation) {
        this.targetingInformation = targetingInformation;
    }

    /**
     * Returns the content targeting url for this request.
     * @return String with content targeting url.
     */
    public String getContentTargetingUrl() {
        return contentTargetingUrl;
    }

    /**
     * Sets the content targeting url for this request
     * @param contentTargetingUrl String with content targeting url
     */
    public void setContentTargetingUrl(String contentTargetingUrl) {
        this.contentTargetingUrl = contentTargetingUrl;
    }

    boolean wasUtilized() {
        return wasUtilized;
    }

    void setWasUtilized(boolean wasUtilized) {
        this.wasUtilized = wasUtilized;
    }

    boolean isCancelled() {
        return cancelled;
    }

    void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    void setCompletionListener(BannerRequestCompletionListener listener) {
        this.completionListener = listener;
    }

    BannerRequestCompletionListener getCompletionListener() {
        return completionListener;
    }

    @NonNull
    @Override
    public String toString() {
        return "BannerRequest{" +
                "bannerSizes=" + bannerSizes +
                ", delegate=" + delegate +
                ", targetingInformation=" + targetingInformation +
                ", contentTargetingUrl=" + contentTargetingUrl +
                ", @" + Integer.toHexString(hashCode()) + '}';
    }
}
