package com.intentsoftware.addapptr;

/**
 * The delegate that can be used to customize the banner request with regards to keyword targeting. If no delegate is set, all networks will get the targeting information.
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public interface BannerRequestDelegate {

    /**
     * Decides if for a given request and {@link AdNetwork} the targeting information should be passed.
     * @param request The {@link BannerRequest} for which the decission is being made.
     * @param network The {@link AdNetwork} for which the decission is being made.
     * @return True if targeting should be used, false otherwise.
     */
    boolean shouldUseTargeting(BannerRequest request, AdNetwork network);
}
