package com.intentsoftware.addapptr;

public enum BannerSize {
    Banner320x53("320x53", 320, 53),
    Banner768x90("768x90", 768, 90),
    Banner300x250("300x250", 300, 250),
    Banner468x60("468x60", 468, 60),
    MultipleSizes("Multiple-Sizes", 0, 0),
    Banner320x75("320x75", 320, 75),
    Banner320x100("320x100", 320, 100),
    Banner320x150("320x150", 320, 150),
    Banner320x160("320x160", 320, 160),
    Banner320x480("320x480", 320, 480);

    private final String configName;
    private final int width;
    private final int height;

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    BannerSize(String configName, int width, int height) {
        this.configName = configName;
        this.width = width;
        this.height = height;
    }

    public static BannerSize fromServerConfigName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }

        for (BannerSize n : BannerSize.values()) {
            if (n.configName.equals(name)) {
                return n;
            }
        }
        return null;
    }

}
