package com.intentsoftware.addapptr;

/**
 * Allows to set the status of Non-IAB consent. Will also read the IAB consent string from SharedPreferences if available.
 */
public class SimpleConsent extends ConsentImplementation {

    private final NonIABConsent nonIABConsent;

    /**
     * Creates the {@link SimpleConsent} instance.
     *
     * @param nonIABConsent The status of GDPR consent for non-IAB partners.
     */
    public SimpleConsent(NonIABConsent nonIABConsent) {
        this.nonIABConsent = nonIABConsent;
    }

    NonIABConsent getNonIABConsent() {
        return nonIABConsent;
    }

    @Override
    NonIABConsent getConsentForNetwork(AdNetwork network) {
        return nonIABConsent;
    }

    @Override
    public String toString() {
        return "SimpleConsent{" +
                "nonIABConsent=" + nonIABConsent +
                ", consentStringVersion= " + getConsentStringVersion() +
                ", consentString=" + getConsentString() +
                "} " + super.toString();
    }
}
