package com.intentsoftware.addapptr.ad.vast;

import com.intentsoftware.addapptr.AdNetwork;
import com.intentsoftware.addapptr.VASTRequestParameters;

import java.util.HashMap;

/**
 * Allows to define request parameters. For more details about parameters names, refer to the <a href="https://support.google.com/dfp_premium/answer/1068325?hl=en&amp;ref_topic=2480647#cust_params">DFP VAST
 * documentation available online.</a>
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class DFPVASTRequestParameters extends VASTRequestParameters {

    /**
     * Defines the 'ad_rule' request parameter
     */
    public Integer adRule;

    /**
     * Defines the 'ciu_szs' request parameter.
     */
    public String listOfSizes;

    /**
     * Defines the 'cmsid' request parameter.
     */
    public String cmsid;

    /**
     * Defines the 'vid' request parameter.
     */
    public String vid;

    /**
     * Defines the 'hl' request parameter.
     */
    public String hl;

    /**
     * Defines the 'nofb' request parameter.
     */
    public Integer nofb;

    /**
     * Defines the 'pp' request parameter.
     */
    public String publisherProvider;

    /**
     * Defines the 'scp' request parameter.
     */
    public String customParameters;

    /**
     * Defines the 'tfcd' request parameter.
     */
    public Boolean coppa;

    /**
     * Defines the 'max_ad_duration' request parameter.
     */
    public Integer maxDurationInSeconds;

    /**
     * Defines the 'min_ad_duration' request parameter.
     */
    public Integer minDurationInSeconds;

    /**
     * Defines the 'sz' request parameter.
     */
    public String size;

    /**
     * Defines the 'unviewed_position_start' request parameter.
     */
    public Boolean isDelayedImpression;

    /**
     * Defines the 'ppid' request parameter.
     */
    public String publisherId;

    /**
     * Defines the 'description_url' request parameter.
     */
    public String descriptionUrl;

    /**
     * Defines the 'output' request parameter.
     */
    public String outputFormat;

    /**
     * Defines the 'pod' request parameter.
     */
    public Integer pod;

    /**
     * Defines the 'ppos' request parameter.
     */
    public Integer ppos;

    /**
     * Defines the 'mridx' request parameter.
     */
    public Integer mridx;

    /**
     * Defines the 'lip' request parameter.
     */
    public Boolean lip;

    /**
     * Defines the 'pmnd' request parameter.
     */
    public Long pmnd;

    /**
     * Defines the 'pmxd' request parameter.
     */
    public Long pmxd;

    /**
     * Defines the 'pmad' request parameter.
     */
    public Integer pmad;


    @Override
    public HashMap<String, String> getRequestParameters() {
        HashMap<String, String> map = new HashMap<>();

        addParameterToRequestMap("ad_rule", adRule, map);
        addParameterToRequestMap("ciu_szs", listOfSizes, map);
        addParameterToRequestMap("cmsid", cmsid, map);
        addParameterToRequestMap("vid", vid, map);
        addParameterToRequestMap("hl", hl, map);
        addParameterToRequestMap("nofb", nofb, map);
        addParameterToRequestMap("pp", publisherProvider, map);
        addParameterToRequestMap("scp", customParameters, map);
        if (VASTVersion != null && outputFormat == null) {
            map.put("output", "xml_vast" + VASTVersion);
        }
        addParameterToRequestMap("output", outputFormat, map);

        addParameterToRequestMap("vpos", convertVideoTypeToParameterValue(videoType), map);
        addParameterToRequestMap("tfcd", coppa, map);
        addParameterToRequestMap("max_ad_duration", maxDurationInSeconds, map);
        addParameterToRequestMap("min_ad_duration", minDurationInSeconds, map);
        addParameterToRequestMap("sz", size, map);
        addParameterToRequestMap("unviewed_position_start", isDelayedImpression, map);
        addParameterToRequestMap("ppid", publisherId, map);
        addParameterToRequestMap("description_url", descriptionUrl, map);

        addParameterToRequestMap("pod", pod, map);

        addParameterToRequestMap("ppos", ppos, map);

        addParameterToRequestMap("mridx", mridx, map);

        if (lip) {
            map.put("lip", "true");
        }

        addParameterToRequestMap("pmnd", pmnd, map);

        addParameterToRequestMap("pmxd", pmxd, map);

        addParameterToRequestMap("pmad", pmad, map);

        return map;
    }

    static String convertVideoTypeToParameterValue(VideoType videoType) {
        String result;

        switch (videoType) {
            case PreRoll:
                result = "preroll";
                break;
            case MidRoll:
                result = "midroll";
                break;
            case PostRoll:
                result = "postroll";
                break;
            default:
                result = null;
                break;
        }

        return result;
    }

    @Override
    public AdNetwork getAdNetwork() {
        return AdNetwork.DFP;
    }
}
