package com.intentsoftware.addapptr.ad.vast;

import com.intentsoftware.addapptr.AdNetwork;
import com.intentsoftware.addapptr.VASTRequestParameters;

import java.util.HashMap;

/**
 * Allows to define request parameters. For more details about parameters names, refer to the
 * <a href="https://support.smartadserver.com/s/article/ka00Y000000Ys4QQAS/Video-RTB-parameters">Smart Ad Server VAST documentation available online.</a>
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class SmartAdServerVASTRequestParameters extends VASTRequestParameters {

    /**
     * Defines the 'pgdomain' request parameter.
     */
    public String pageDomain;

    /**
     * Defines the 'vph' request parameter.
     */
    public Integer height;

    /**
     * Defines the 'vpw' request parameter.
     */
    public Integer width;

    /**
     * Defines the 'vdmax' request parameter.
     */
    public Integer maxDurationInSeconds;

    /**
     * Defines the 'vdmin' request parameter.
     */
    public Integer minDurationInSeconds;

    /**
     * Defines the 'vaf' request parameter.
     */
    public Boolean flashVideoAccepted;

    /**
     * Defines the 'vpmt' request parameter.
     */
    public Integer playbackMethod;

    /**
     * Defines the 'vbrmin' request parameter.
     */
    public Integer minBitRate;

    /**
     * Defines the 'vbrmax' request parameter.
     */
    public Integer maxBitRate;

    @Override
    public HashMap<String, String> getRequestParameters() {
        HashMap<String, String> map = new HashMap<>();

        addParameterToRequestMap("pgdomain", pageDomain, map);
        if (VASTVersion != null) {
            map.put("out", "vast" + VASTVersion);
        }

        addParameterToRequestMap("ab", convertVideoTypeToParameterValue(videoType), map);
        addParameterToRequestMap("vdmax", maxDurationInSeconds, map);
        addParameterToRequestMap("vdmin", minDurationInSeconds, map);

        addParameterToRequestMap("vbrmin", minBitRate, map);
        addParameterToRequestMap("vbrmax", maxBitRate, map);

        addParameterToRequestMap("vph", height, map);
        addParameterToRequestMap("vpw", width, map);

        addParameterToRequestMap("vpmt", playbackMethod, map);
        addParameterToRequestMap("vaf", flashVideoAccepted, map);

        return map;
    }

    @Override
    public AdNetwork getAdNetwork() {
        return AdNetwork.SMARTAD;
    }

    static String convertVideoTypeToParameterValue(VideoType videoType) {
        String result;

        switch (videoType) {
            case PreRoll:
                result = "1";
                break;
            case MidRoll:
                result = "2";
                break;
            case PostRoll:
                result = "3";
                break;
            default:
                result = null;
                break;
        }

        return result;
    }
}
