package com.intentsoftware.addapptr.ad.vast;

import com.intentsoftware.addapptr.AdNetwork;
import com.intentsoftware.addapptr.VASTRequestParameters;

import java.util.HashMap;


/**
 * Allows to define request parameters. For more details about parameters names, refer to the
 * <a href="https://developer.spotxchange.com/content/local/docs/publisher-resources/Supported-Parameters.md">SpotX VAST documentation available online.</a>
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class SpotXVASTRequestParameters extends VASTRequestParameters {

    /**
     * Defines the 'app[cat]' request parameter.
     */
    public String appCat;

    /**
     * Defines the 'app[domain]' request parameter.
     */
    public String appDomain;

    /**
     * Defines the 'app[qagmediarating]' request parameter.
     */
    public String appQagmediarating;

    /**
     * Defines the 'app[name]' request parameter.
     */
    public String appName;

    /**
     * Defines the 'app[privacypolicy]' request parameter.
     */
    public String appPrivacypolicy;

    /**
     * Defines the 'app[storeurl]' request parameter.
     */
    public String appStoreUrl;

    /**
     * Defines the 'app[ver]' request parameter.
     */
    public String appVersion;

    /**
     * Defines the 'app[uid]' request parameter.
     */
    public String appUId;

    /**
     * Defines the 'max_bitrate' request parameter.
     */
    public Integer maxBitrate;

    /**
     * Defines the 'max_height' request parameter.
     */
    public Integer maxHeight;

    /**
     * Defines the 'max_width' request parameter.
     */
    public Integer maxWidth;

    /**
     * Defines the 'min_bitrate' request parameter.
     */
    public Integer minBitrate;

    /**
     * Defines the 'min_height' request parameter.
     */
    public Integer minHeight;

    /**
     * Defines the 'min_width' request parameter.
     */
    public Integer minWidth;

    /**
     * Defines the 'player_height' request parameter.
     */
    public Integer playerHeight;

    /**
     * Defines the 'player_width' request parameter.
     */
    public Integer playerWidth;

    /**
     * Defines the 'playtime' request parameter.
     */
    public Float playTime;

    /**
     * Defines the 'regs[coppa]' request parameter.
     */
    public Boolean coppa;

    /**
     * Defines the 'vpix' request parameter.
     */
    public String vpix;

    /**
     * Defines the 'VPAID' request parameter.
     */
    public String VPAID;

    /**
     * Defines the 'content[all_rating]' request parameter.
     */
    public String contentAllRating;

    /**
     * Defines the 'content[cat]' request parameter.
     */
    public String contentCat;

    /**
     * Defines the 'content[company_url]' request parameter.
     */
    public String contentCompanyUrl;

    /**
     * Defines the 'content[qagmediarating]' request parameter.
     */
    public String contentQagmediarating;

    /**
     * Defines the 'content[id]' request parameter.
     */
    public String contentId;

    /**
     * Defines the 'content[series]' request parameter.
     */
    public String contentSeries;

    /**
     * Defines the 'content[title]' request parameter.
     */
    public String contentTitle;

    @Override
    public HashMap<String, String> getRequestParameters() {

        HashMap<String, String> map = new HashMap<>();

        addParameterToRequestMap("app[cat]", appCat, map);
        addParameterToRequestMap("app[domain]", appDomain, map);
        addParameterToRequestMap("app[qagmediarating]", appQagmediarating, map);
        addParameterToRequestMap("app[name]", appName, map);
        addParameterToRequestMap("app[privacypolicy]", appPrivacypolicy, map);
        addParameterToRequestMap("app[storeurl]", appStoreUrl, map);
        addParameterToRequestMap("app[ver]", appVersion, map);
        addParameterToRequestMap("app[uid]", appUId, map);
        addParameterToRequestMap("max_bitrate", maxBitrate, map);
        addParameterToRequestMap("max_height", maxHeight, map);
        addParameterToRequestMap("max_width", maxWidth, map);
        addParameterToRequestMap("min_bitrate", minBitrate, map);
        addParameterToRequestMap("min_height", minHeight, map);
        addParameterToRequestMap("min_width", minWidth, map);
        addParameterToRequestMap("player_height", playerHeight, map);
        addParameterToRequestMap("player_width", playerWidth, map);
        addParameterToRequestMap("playtime", playTime, map);
        addParameterToRequestMap("regs[coppa]", coppa, map);
        addParameterToRequestMap("vpix", vpix, map);
        addParameterToRequestMap("VPAID", VPAID, map);

        addParameterToRequestMap("content[all_rating]", contentAllRating, map);
        addParameterToRequestMap("content[cat]", contentCat, map);
        addParameterToRequestMap("content[company_url]", contentCompanyUrl, map);
        addParameterToRequestMap("content[qagmediarating]", contentQagmediarating, map);
        addParameterToRequestMap("content[id]", contentId, map);
        addParameterToRequestMap("content[series]", contentSeries, map);
        addParameterToRequestMap("content[title]", contentTitle, map);

        return map;
    }

    @Override
    public AdNetwork getAdNetwork() {
        return AdNetwork.SPOTX;
    }
}
