package com.intentsoftware.addapptr

import android.util.Log
import com.intentsoftware.addapptr.internal.module.Logger.e
import com.intentsoftware.addapptr.internal.module.Logger.isLoggable

/**
 * The configuration object to be used when creating a banner placement.
 */
class BannerConfiguration {

    /**
     * Returns the number of ad requests that can be made simultaneously.
     *
     * @return The number of ad requests that can be made simultaneously.
     */
    /**
     * Sets the number of ad requests that can be made simultaneously.
     *
     * @param numberOfWorkers The number of ad requests that can be made simultaneously. Must be greater than 0.
     */
    var numberOfWorkers = 3
        set(numberOfWorkers) {
            if (numberOfWorkers > 0) {
                field = numberOfWorkers
            } else {
                if (isLoggable(Log.ERROR)) {
                    e(AATKit::class.java, "Number of workers must be greater than 0.")
                }
            }
        }

    /**
     * Checks if manual adspace counting is enabled.
     *
     * @return Boolean indicating if manual adspace counting is enabled.
     */
    /**
     * Allows to set if manual adspace counting should be used. If manual adspace counting is disabled, adspace is counted on every banner request.
     *
     * @param manualAdSpaceCounting Boolean indicating if manual adspace counting should be enabled.
     */
    var isManualAdSpaceCounting = false

    /**
     * Constructs new BannerConfguration to be used when creating new [BannerPlacement].
     */
    constructor()
    internal constructor(configuration: BannerConfiguration) {
        numberOfWorkers = configuration.numberOfWorkers
        isManualAdSpaceCounting = configuration.isManualAdSpaceCounting
    }

    override fun toString(): String {
        return "BannerConfiguration{" +
                "numberOfWorkers=" + numberOfWorkers +
                ", manualAdSpaceCounting=" + isManualAdSpaceCounting +
                ", @" + Integer.toHexString(hashCode()) + '}'
    }
}