package com.intentsoftware.addapptr

/**
 * Allows to change settings for AATKit at runtime.
 */
open class AATKitRuntimeConfiguration {
    /**
     * Sets if the GDPR consent is required (if the user falls under GDPR jurisdiction). True by default.
     *
     * @param consentRequired True if user falls under GDPR jurisdiction, false otherwise.
     */
    var isConsentRequired = true

    /**
     * Sets the detailed consent for GDPR.
     * @param consent Instance of [AATKit.Consent] to be used.
     */
    var consent: AATKit.Consent? = null

    /**
     * Sets if geo data (if it is available) should be sent. Disabled by default.
     * @param useGeoLocation True to enable, false to disable
     */
    var isUseGeoLocation = false

    override fun toString(): String {
        return "AATKitRuntimeConfiguration{" +
                "consentRequired=" + isConsentRequired +
                ", consent=" + consent +
                ", useGeoLocation=" + isUseGeoLocation +
                '}'
    }

    companion object {
        private var oldConfiguration: AATKitRuntimeConfiguration? = null
    }

    /**
     * Creates the AATKitRuntimeConfiguration object to be used when reconfiguring AATKit.
     * It will be automatically initialized with previously used values.
     */
    init {
        oldConfiguration?.let {
            isConsentRequired = it.isConsentRequired
            consent = it.consent
            isUseGeoLocation = it.isUseGeoLocation
        }
        oldConfiguration = this
    }
}