package com.intentsoftware.addapptr

/**
 * Placement used for obtaining banner ads.
 */
interface BannerPlacement {
    /**
     * Requests a new banner ad.
     * @param request [BannerRequest] instance. Can not be null.
     * @param listener [BannerRequestCompletionListener] instance that will be called when the request finishes. Can not be null.
     */
    fun requestAd(request: BannerRequest?, listener: BannerRequestCompletionListener?)

    /**
     * Cancels the given banner request.
     * @param request Request that should be canceled.
     */
    fun cancel(request: BannerRequest)

    /**
     * Counts the adspace for statistics. Can only be called if manual adspace counting is used.
     * @see BannerConfiguration.setManualAdSpaceCounting
     */
    fun countAdSpace()
}