package com.intentsoftware.addapptr

/**
 * The delegate that can be used to customize the banner request with regards to keyword targeting. If no delegate is set, all networks will get the targeting information.
 */
interface BannerRequestDelegate {
    /**
     * Decides if for a given request and [AdNetwork] the targeting information should be passed.
     * @param request The [BannerRequest] for which the decission is being made.
     * @param network The [AdNetwork] for which the decission is being made.
     * @return True if targeting should be used, false otherwise.
     */
    fun shouldUseTargeting(request: BannerRequest, network: AdNetwork?): Boolean
}