package com.intentsoftware.addapptr.ad.vast

import com.intentsoftware.addapptr.AdNetwork
import com.intentsoftware.addapptr.VASTRequestParameters

/**
 * Allows to define request parameters. For more details about parameters names, refer to the [&amp;DFP VAST
 * documentation available online.](https://support.google.com/dfp_premium/answer/1068325?hl=en&amp;ref_topic=2480647#cust_params)
 */
class DFPVASTRequestParameters : VASTRequestParameters() {
    /**
     * Defines the 'ad_rule' request parameter
     */
    @JvmField
    var adRule: Int? = null

    /**
     * Defines the 'ciu_szs' request parameter.
     */
    @JvmField
    var listOfSizes: String? = null

    /**
     * Defines the 'cmsid' request parameter.
     */
    @JvmField
    var cmsid: String? = null

    /**
     * Defines the 'vid' request parameter.
     */
    @JvmField
    var vid: String? = null

    /**
     * Defines the 'hl' request parameter.
     */
    @JvmField
    var hl: String? = null

    /**
     * Defines the 'nofb' request parameter.
     */
    @JvmField
    var nofb: Int? = null

    /**
     * Defines the 'pp' request parameter.
     */
    @JvmField
    var publisherProvider: String? = null

    /**
     * Defines the 'scp' request parameter.
     */
    @JvmField
    var customParameters: String? = null

    /**
     * Defines the 'tfcd' request parameter.
     */
    @JvmField
    var coppa: Boolean? = null

    /**
     * Defines the 'max_ad_duration' request parameter.
     */
    @JvmField
    var maxDurationInSeconds: Int? = null

    /**
     * Defines the 'min_ad_duration' request parameter.
     */
    @JvmField
    var minDurationInSeconds: Int? = null

    /**
     * Defines the 'sz' request parameter.
     */
    @JvmField
    var size: String? = null

    /**
     * Defines the 'unviewed_position_start' request parameter.
     */
    @JvmField
    var isDelayedImpression: Boolean? = null

    /**
     * Defines the 'ppid' request parameter.
     */
    @JvmField
    var publisherId: String? = null

    /**
     * Defines the 'description_url' request parameter.
     */
    @JvmField
    var descriptionUrl: String? = null

    /**
     * Defines the 'output' request parameter.
     */
    @JvmField
    var outputFormat: String? = null

    /**
     * Defines the 'pod' request parameter.
     */
    @JvmField
    var pod: Int? = null

    /**
     * Defines the 'ppos' request parameter.
     */
    @JvmField
    var ppos: Int? = null

    /**
     * Defines the 'mridx' request parameter.
     */
    @JvmField
    var mridx: Int? = null

    /**
     * Defines the 'lip' request parameter.
     */
    @JvmField
    var lip: Boolean? = null

    /**
     * Defines the 'pmnd' request parameter.
     */
    @JvmField
    var pmnd: Long? = null

    /**
     * Defines the 'pmxd' request parameter.
     */
    @JvmField
    var pmxd: Long? = null

    /**
     * Defines the 'pmad' request parameter.
     */
    @JvmField
    var pmad: Int? = null


    override val requestParameters: MutableMap<String, String>
        get() {
            val map = mutableMapOf<String, String>()
            addParameterToRequestMap("ad_rule", adRule, map)
            addParameterToRequestMap("ciu_szs", listOfSizes, map)
            addParameterToRequestMap("cmsid", cmsid, map)
            addParameterToRequestMap("vid", vid, map)
            addParameterToRequestMap("hl", hl, map)
            addParameterToRequestMap("nofb", nofb, map)
            addParameterToRequestMap("pp", publisherProvider, map)
            addParameterToRequestMap("scp", customParameters, map)
            if (VASTVersion != null && outputFormat == null) {
                map["output"] = "xml_vast$VASTVersion"
            }
            addParameterToRequestMap("output", outputFormat, map)
            addParameterToRequestMap("vpos", convertVideoTypeToParameterValue(videoType), map)
            addParameterToRequestMap("tfcd", coppa, map)
            addParameterToRequestMap("max_ad_duration", maxDurationInSeconds, map)
            addParameterToRequestMap("min_ad_duration", minDurationInSeconds, map)
            addParameterToRequestMap("sz", size, map)
            addParameterToRequestMap("unviewed_position_start", isDelayedImpression, map)
            addParameterToRequestMap("ppid", publisherId, map)
            addParameterToRequestMap("description_url", descriptionUrl, map)
            addParameterToRequestMap("pod", pod, map)
            addParameterToRequestMap("ppos", ppos, map)
            addParameterToRequestMap("mridx", mridx, map)

            lip?.let {
                if (it) {
                    map["lip"] = "true"
                }
            }

            addParameterToRequestMap("pmnd", pmnd, map)
            addParameterToRequestMap("pmxd", pmxd, map)
            addParameterToRequestMap("pmad", pmad, map)
            return map
        }

    override val adNetwork: AdNetwork
        get() = AdNetwork.DFP

    companion object {
        @JvmStatic
        fun convertVideoTypeToParameterValue(videoType: VideoType?): String? {
            var result: String? = null
            if (videoType != null) {
                result = when (videoType) {
                    VideoType.PreRoll -> "preroll"
                    VideoType.MidRoll -> "midroll"
                    VideoType.PostRoll -> "postroll"
                }
            }
            return result
        }
    }
}