package com.intentsoftware.addapptr.ad.vast

import com.intentsoftware.addapptr.AdNetwork
import com.intentsoftware.addapptr.VASTRequestParameters
import java.util.*

/**
 * Allows to define request parameters. For more details about parameters names, refer to the
 * [Smart Ad Server VAST documentation available online.](https://support.smartadserver.com/s/article/ka00Y000000Ys4QQAS/Video-RTB-parameters)
 */
class SmartAdServerVASTRequestParameters : VASTRequestParameters() {
    /**
     * Defines the 'pgdomain' request parameter.
     */
    @JvmField
    var pageDomain: String? = null

    /**
     * Defines the 'vph' request parameter.
     */
    @JvmField
    var height: Int? = null

    /**
     * Defines the 'vpw' request parameter.
     */
    @JvmField
    var width: Int? = null

    /**
     * Defines the 'vdmax' request parameter.
     */
    @JvmField
    var maxDurationInSeconds: Int? = null

    /**
     * Defines the 'vdmin' request parameter.
     */
    @JvmField
    var minDurationInSeconds: Int? = null

    /**
     * Defines the 'vaf' request parameter.
     */
    @JvmField
    var flashVideoAccepted: Boolean? = null

    /**
     * Defines the 'vpmt' request parameter.
     */
    @JvmField
    var playbackMethod: Int? = null

    /**
     * Defines the 'vbrmin' request parameter.
     */
    @JvmField
    var minBitRate: Int? = null

    /**
     * Defines the 'vbrmax' request parameter.
     */
    @JvmField
    var maxBitRate: Int? = null

    override val requestParameters: MutableMap<String, String>
        get() {
            val map = HashMap<String, String>()
            addParameterToRequestMap("pgdomain", pageDomain, map)
            if (VASTVersion != null) {
                map["out"] = "vast$VASTVersion"
            }
            addParameterToRequestMap("ab", convertVideoTypeToParameterValue(videoType), map)
            addParameterToRequestMap("vdmax", maxDurationInSeconds, map)
            addParameterToRequestMap("vdmin", minDurationInSeconds, map)
            addParameterToRequestMap("vbrmin", minBitRate, map)
            addParameterToRequestMap("vbrmax", maxBitRate, map)
            addParameterToRequestMap("vph", height, map)
            addParameterToRequestMap("vpw", width, map)
            addParameterToRequestMap("vpmt", playbackMethod, map)
            addParameterToRequestMap("vaf", flashVideoAccepted, map)
            return map
        }


    override val adNetwork: AdNetwork
        get() = AdNetwork.SMARTAD

    companion object {
        @JvmStatic
        fun convertVideoTypeToParameterValue(videoType: VideoType?): String? {
            val result: String? = when (videoType) {
                VideoType.PreRoll -> "1"
                VideoType.MidRoll -> "2"
                VideoType.PostRoll -> "3"
                else -> null
            }
            return result
        }
    }
}