package com.intentsoftware.addapptr.ad.vast

import com.intentsoftware.addapptr.VASTRequestParameters
import com.intentsoftware.addapptr.AdNetwork
import java.util.HashMap

/**
 * Allows to define request parameters. For more details about parameters names, refer to the
 * [SpotX VAST documentation available online.](https://developer.spotxchange.com/content/local/docs/publisher-resources/Supported-Parameters.md)
 */
@Suppress("KDocUnresolvedReference", "PropertyName")
class SpotXVASTRequestParameters : VASTRequestParameters() {
    /**
     * Defines the 'app[cat]' request parameter.
     */
    @JvmField
    var appCat: String? = null

    /**
     * Defines the 'app[domain]' request parameter.
     */
    @JvmField
    var appDomain: String? = null

    /**
     * Defines the 'app[qagmediarating]' request parameter.
     */
    @JvmField
    var appQagmediarating: String? = null

    /**
     * Defines the 'app[name]' request parameter.
     */
    @JvmField
    var appName: String? = null

    /**
     * Defines the 'app[privacypolicy]' request parameter.
     */
    @JvmField
    var appPrivacypolicy: String? = null

    /**
     * Defines the 'app[storeurl]' request parameter.
     */
    @JvmField
    var appStoreUrl: String? = null

    /**
     * Defines the 'app[ver]' request parameter.
     */
    @JvmField
    var appVersion: String? = null

    /**
     * Defines the 'app[uid]' request parameter.
     */
    @JvmField
    var appUId: String? = null

    /**
     * Defines the 'max_bitrate' request parameter.
     */
    @JvmField
    var maxBitrate: Int? = null

    /**
     * Defines the 'max_height' request parameter.
     */
    @JvmField
    var maxHeight: Int? = null

    /**
     * Defines the 'max_width' request parameter.
     */
    @JvmField
    var maxWidth: Int? = null

    /**
     * Defines the 'min_bitrate' request parameter.
     */
    @JvmField
    var minBitrate: Int? = null

    /**
     * Defines the 'min_height' request parameter.
     */
    @JvmField
    var minHeight: Int? = null

    /**
     * Defines the 'min_width' request parameter.
     */
    @JvmField
    var minWidth: Int? = null

    /**
     * Defines the 'player_height' request parameter.
     */
    @JvmField
    var playerHeight: Int? = null

    /**
     * Defines the 'player_width' request parameter.
     */
    @JvmField
    var playerWidth: Int? = null

    /**
     * Defines the 'playtime' request parameter.
     */
    @JvmField
    var playTime: Float? = null

    /**
     * Defines the 'regs[coppa]' request parameter.
     */
    @JvmField
    var coppa: Boolean? = null

    /**
     * Defines the 'vpix' request parameter.
     */
    @JvmField
    var vpix: String? = null

    /**
     * Defines the 'VPAID' request parameter.
     */
    @JvmField
    var VPAID: String? = null

    /**
     * Defines the 'content[all_rating]' request parameter.
     */
    @JvmField
    var contentAllRating: String? = null

    /**
     * Defines the 'content[cat]' request parameter.
     */
    @JvmField
    var contentCat: String? = null

    /**
     * Defines the 'content[company_url]' request parameter.
     */
    @JvmField
    var contentCompanyUrl: String? = null

    /**
     * Defines the 'content[qagmediarating]' request parameter.
     */
    @JvmField
    var contentQagmediarating: String? = null

    /**
     * Defines the 'content[id]' request parameter.
     */
    @JvmField
    var contentId: String? = null

    /**
     * Defines the 'content[series]' request parameter.
     */
    @JvmField
    var contentSeries: String? = null

    /**
     * Defines the 'content[title]' request parameter.
     */
    @JvmField
    var contentTitle: String? = null

    override val requestParameters: MutableMap<String, String>
        get() {
            val map = HashMap<String, String>()
            addParameterToRequestMap("app[cat]", appCat, map)
            addParameterToRequestMap("app[domain]", appDomain, map)
            addParameterToRequestMap("app[qagmediarating]", appQagmediarating, map)
            addParameterToRequestMap("app[name]", appName, map)
            addParameterToRequestMap("app[privacypolicy]", appPrivacypolicy, map)
            addParameterToRequestMap("app[storeurl]", appStoreUrl, map)
            addParameterToRequestMap("app[ver]", appVersion, map)
            addParameterToRequestMap("app[uid]", appUId, map)
            addParameterToRequestMap("max_bitrate", maxBitrate, map)
            addParameterToRequestMap("max_height", maxHeight, map)
            addParameterToRequestMap("max_width", maxWidth, map)
            addParameterToRequestMap("min_bitrate", minBitrate, map)
            addParameterToRequestMap("min_height", minHeight, map)
            addParameterToRequestMap("min_width", minWidth, map)
            addParameterToRequestMap("player_height", playerHeight, map)
            addParameterToRequestMap("player_width", playerWidth, map)
            addParameterToRequestMap("playtime", playTime, map)
            addParameterToRequestMap("regs[coppa]", coppa, map)
            addParameterToRequestMap("vpix", vpix, map)
            addParameterToRequestMap("VPAID", VPAID, map)
            addParameterToRequestMap("content[all_rating]", contentAllRating, map)
            addParameterToRequestMap("content[cat]", contentCat, map)
            addParameterToRequestMap("content[company_url]", contentCompanyUrl, map)
            addParameterToRequestMap("content[qagmediarating]", contentQagmediarating, map)
            addParameterToRequestMap("content[id]", contentId, map)
            addParameterToRequestMap("content[series]", contentSeries, map)
            addParameterToRequestMap("content[title]", contentTitle, map)
            return map
        }

    override val adNetwork: AdNetwork
        get() = AdNetwork.SPOTX
}