package com.intentsoftware.addapptr

import android.graphics.drawable.Drawable

/**
 * Allows to pass network-specific configurations to AATKit.
 */
class AATKitAdNetworkOptions(
    var appNexusOptions: AppNexusOptions? = null,
    var feedAdOptions: FeedAdOptions? = null,
    var adMobOptions: AdMobOptions? = null,
    var dfpOptions: DFPOptions? = null,
    var superAwesomeOptions: SuperAwesomeOptions? = null,
    var graviteRTBOptions: GraviteRTBOptions? = null,
    var displayIOBanner: DisplayIOOptions? = null
)

/**
 * FeedAd specific configurations
 */
class FeedAdOptions(
    /**
     * Desired color-int (as obtained from [android.graphics.Color.parseColor]) to be used for shutter. Default is null.
     */
    var shutterColor: Int? = null,

    /**
     * Boolean that describes if spinner should be disabled, default is false.
     */
    var disableSpinner: Boolean = false
)

/**
 * AppNexus specific configuration
 */
class AppNexusOptions(
    /**
     * A delay in seconds after which  a full-screen ad will be dismissed. Default value is null.
     */
    var autoCloseTime: Int? = null,

    /**
     * A Boolean that describes if Banner Ad can serve a Native Ad, default is false.
     */
    var supportNativeBanner: Boolean = false,

    /**
     * A Boolean that describes if Banner Ad can serve Video Ads, default is false.
     */
    var supportVideoBanner: Boolean = false
)

/**
 * AdMob specific configuration
 */
class AdMobOptions(
    /**
     * Maximum height for AdMob inline adaptive banners
     */
    var inlineBannerMaxHeight: Int?
)

/**
 * DFP specific configuration
 */
class DFPOptions(
    /**
     * Maximum height for DFP inline adaptive banners
     */
    var inlineBannerMaxHeight: Int?
)

/**
 * SuperAwesome specific configuration
 */
class SuperAwesomeOptions(
    var bannerOptions: BannerOptions?,
    var interstitialAdOptions: InterstitialAdOptions?,
    var rewardedVideoOptionsOptions: RewardedVideoOptions?
) {
    enum class Orientation {
        ANY,
        PORTRAIT,
        LANDSCAPE,
    }

    enum class CloseButtonState {
        ENABLED,
        ENABLED_NO_DELAY,
        DISABLED
    }

    interface NetworkOptions {
        /**
         * The Parental gate is a dialog that appears when a user clicks on an ad,  disabled by default.
         * recommended to set it to true if the app is in kids category.
         */
        var parentalGateEnabled: Boolean?

        /**
         * The Bumper page is a customizable dialog that notifies the user when they are about to leave a kid-safe place and proceed to an external website.
         * disabled by default.
         */
        var bumperPageEnabled: Boolean?

        /**
         * Set app name to be displayed on the bumper page. By default, the Bumper page displays the application name.
         */
        var bumperPageCustomAppName: String?

        /**
         * Set logo to be displayed on the bumper page. By default, the Bumper page displays the AwesomeAds logo
         */
        var bumperPageLogo: Drawable?
    }

    interface InterstitialNetworkOption : NetworkOptions {
        /**
         * set the desired orientation to show the Ad in, note that your app must support the specified orientation.
         */
        var orientation: Orientation?

        /**
         * Set wether the close button should be displayed after delay or immediately
         * The close button is displayed after a 1 second delay by default on interstitial ads unless settings are changed to disable it.
         */
        var closeButtonState: CloseButtonState?
    }

    class BannerOptions() : NetworkOptions {
        override var parentalGateEnabled: Boolean? = false
        override var bumperPageEnabled: Boolean? = false
        override var bumperPageCustomAppName: String? = null
        override var bumperPageLogo: Drawable? = null

        /**
         * set whether the banner background is transparent or gray.
         */
        var isBackgroundTransparent: Boolean? = true

        constructor (
            parentalGateEnabled: Boolean = false,
            bumperPageEnabled: Boolean = false,
            bumperPageCustomAppName: String? = null,
            bumperPageLogo: Drawable? = null,
            isBackgroundTransparent: Boolean? = true
        ) : this() {
            this.parentalGateEnabled = parentalGateEnabled
            this.bumperPageEnabled = bumperPageEnabled
            this.bumperPageCustomAppName = bumperPageCustomAppName
            this.bumperPageLogo = bumperPageLogo
            this.isBackgroundTransparent = isBackgroundTransparent
        }
    }

    class InterstitialAdOptions() : InterstitialNetworkOption {
        override var parentalGateEnabled: Boolean? = false
        override var bumperPageEnabled: Boolean? = false
        override var bumperPageCustomAppName: String? = null
        override var bumperPageLogo: Drawable? = null
        override var orientation: Orientation? = Orientation.ANY
        override var closeButtonState: CloseButtonState? = CloseButtonState.ENABLED

        constructor(
            parentalGateEnabled: Boolean = false,
            bumperPageEnabled: Boolean = false,
            bumperPageCustomAppName: String? = null,
            bumperPageLogo: Drawable? = null,
            orientation: Orientation? = Orientation.ANY,
            closeButtonState: CloseButtonState? = CloseButtonState.ENABLED,
        ) : this() {
            this.parentalGateEnabled = parentalGateEnabled
            this.bumperPageEnabled = bumperPageEnabled
            this.bumperPageCustomAppName = bumperPageCustomAppName
            this.bumperPageLogo = bumperPageLogo
            this.orientation = orientation
            this.closeButtonState = closeButtonState
        }
    }

    class RewardedVideoOptions() : InterstitialNetworkOption {

        override var parentalGateEnabled: Boolean? = false
        override var bumperPageEnabled: Boolean? = false
        override var bumperPageCustomAppName: String? = null
        override var bumperPageLogo: Drawable? = null
        override var orientation: Orientation? = Orientation.ANY
        override var closeButtonState: CloseButtonState? = CloseButtonState.ENABLED

        /**
         * Enable or disable auto-closing at the end
         */
        var closeButtonAtEnd: Boolean? = false

        /**
         * Enable or disable small click button
         */
        var smallClickEnabled: Boolean? = false

        /**
         * Enable or disable close button warning
         */
        var closeButtonWarningEnabled: Boolean? = false

        constructor(
            parentalGateEnabled: Boolean? = false,
            bumperPageEnabled: Boolean? = false,
            bumperPageCustomAppName: String? = null,
            bumperPageLogo: Drawable? = null,
            orientation: Orientation? = Orientation.ANY,
            closeButtonState: CloseButtonState? = CloseButtonState.ENABLED,
            closeButtonAtEnd: Boolean = false,
            smallClickEnabled: Boolean = false,
            closeButtonWarningEnabled: Boolean = false
        ) : this() {
            this.parentalGateEnabled = parentalGateEnabled
            this.bumperPageEnabled = bumperPageEnabled
            this.bumperPageCustomAppName = bumperPageCustomAppName
            this.bumperPageLogo = bumperPageLogo
            this.orientation = orientation
            this.closeButtonState = closeButtonState
            this.closeButtonAtEnd = closeButtonAtEnd
            this.smallClickEnabled = smallClickEnabled
            this.closeButtonWarningEnabled = closeButtonWarningEnabled
        }
    }
}

/**
 * GraviteRTB specific configurations
 */
class GraviteRTBOptions(
    /**
     * Boolean to force showing the SDK native close button even if the MRAID creative has one
     * If the MRAID creative has close button and ``forceCloseButtonForMraid`` is true, the MRAID creative would have 2 close buttons
     */
    var forceCloseButtonForMraid: Boolean?
)


/**
 * Display.io specific configurations
 */
class DisplayIOOptions(
    /**
     * Set different height to interscroller
     */
    var interscrollerHeight: Int?,

    /**
     * Set different top offset to interscroller
     */
    var interscrollerTopOffset: Int?,
)