package com.intentsoftware.addapptr

import com.intentsoftware.addapptr.internal.AATKitAbstractConfiguration

/**
 * Allows to change settings for AATKit at runtime.
 */
class AATKitRuntimeConfiguration : AATKitAbstractConfiguration() {

    override fun toString(): String {
        return "AATKitRuntimeConfiguration{" +
                "consentRequired=" + isConsentRequired +
                ", consent=" + consent +
                ", useGeoLocation=" + isUseGeoLocation +
                '}'
    }

    companion object {
        private var oldConfiguration: AATKitRuntimeConfiguration? = null
    }

    /**
     * Creates the AATKitRuntimeConfiguration object to be used when reconfiguring AATKit.
     * It will be automatically initialized with previously used values.
     */
    init {
        oldConfiguration?.let {
            isConsentRequired = it.isConsentRequired
            consent = it.consent
            isUseGeoLocation = it.isUseGeoLocation
        }
        oldConfiguration = this
    }
}