package com.intentsoftware.addapptr

import com.intentsoftware.addapptr.internal.ConsentImplementation
import com.intentsoftware.addapptr.internal.ConsentTypeForReporting

/**
 * Allows to set the status of Non-IAB consent. Will also read the IAB consent string and CCPA string from SharedPreferences if available.
 */
class SimpleConsent
/**
 * Creates the [SimpleConsent] instance.
 *
 * @param nonIABConsent The status of GDPR consent for non-IAB partners.
 */(val nonIABConsent: NonIABConsent) : Consent, ConsentImplementation() {
    override val consentTypeForReporting: ConsentTypeForReporting
        get() {
            return if (consentStringVersion == ConsentStringVersion.CONSENT_VERSION_2) {
                ConsentTypeForReporting.SIMPLE_CONSENT_CMP
            } else {
                ConsentTypeForReporting.SIMPLE_CONSENT
            }
        }

    override val consentType: String
        get() = "SimpleConsent"
    override val usedConsent: String
        get() = "nonIABConsent=$nonIABConsent"


    override fun getConsentForNetwork(network: AdNetwork): NonIABConsent {
        return nonIABConsent
    }

    override fun toString(): String {
        return "SimpleConsent{" +
                "nonIABConsent=" + nonIABConsent +
                ", consentStringVersion= " + consentStringVersion +
                ", gdprConsentString=" + gdprConsentString +
                "} " + super.toString()
    }
}