package com.intentsoftware.addapptr


/**
 * Object containing impression level information.
 */
@Suppress("unused", "MemberVisibilityCanBePrivate")
class AATKitImpression internal constructor(
    private val bannerSize: String?,
    val adNetwork: AdNetwork,
    val networkKey: String,
    val isDirectDeal: Boolean,
    val priceInfo: PriceInfo?
) {
    /**
     * Returns the banner size as string (matching the ad key configuration), or null for non-banner ads
     *
     * @return String describing banner size or null for non-banner ads.
     */
    fun getBannerSize(): String? {
        return bannerSize
    }

    /**
     * Returns the network name as string, matching the ad key configuration.
     *
     * @return String describing network name.
     */
    val adNetworkName: String
        get() = adNetwork.name

    override fun toString(): String {
        return "AATKitImpression{" +
                "bannerSize=" + bannerSize +
                ", adNetwork=" + adNetwork +
                ", networkKey='" + networkKey + '\'' +
                ", isDirectDeal=" + isDirectDeal +
                ", priceInfo=" + priceInfo +
                '}'
    }
}