package com.intentsoftware.addapptr

class PriceInfo (
    /**
     * Impression CPM price.
     */
    val price: Double,
    val currency: Currency,
    val precisionType: PrecisionType) {

    enum class Currency {
        UNKNOWN,
        EUR,
        USD
    }

    enum class PrecisionType {
        UNKNOWN,
        ESTIMATED,
        FLOOR_PRICE,
        PUBLISHER_PROVIDED,
        EXACT
    }

    override fun toString(): String {
        return "PriceInfo(price=$price, currency=$currency, precisionType=$precisionType)"
    }
}