package com.intentsoftware.addapptr

import android.graphics.drawable.Drawable
import androidx.annotation.DrawableRes
import java.io.Serializable

class AATKitDebugScreenConfiguration : Serializable {

    internal enum class AATKitShakeScreenLogoAlignment {
        Center,
        Left,
        Right
    }

    var appLogoDrawable: Drawable? = null
        private set

    @DrawableRes
    var appLogoFromResources: Int? = null
        private set

    var title: String?
        private set

    /**
     * Show bundle identifier. Default value is true
     */
    var showBundleId: Boolean = true

    /**
     * Show test mode data. Default value is true
     */
    var showTestMode: Boolean = true

    /**
     * Show loaded/loading ads. Default value is true
     */
    var showLoadedAndLoadingAds: Boolean = true

    /**
     * Show available ad networks. Default value is true
     */
    var showAvailableNetworks: Boolean = true

    /**
     * Show disabled ad networks. Default value is true
     */
    var showDisabledNetworks: Boolean = true

    /**
     * Show removed ad networks. Default value is true
     */
    var showRemovedNetworkSDKs: Boolean = true

    /**
     * Show unsupported ad networks. Default value is true
     */
    var showUnsupportedNetworks: Boolean = true

    /**
     * Show extra SDKs available. Default value is true
     */
    var showExtraSDKs: Boolean = true

    /**
     * Show information about used consent. Default value is true
     */
    var showConsent: Boolean = true

    /**
     * Show Advertising ID. Default value is true
     */
    var showAdvertisingId: Boolean = true

    /**
     * Logo alignment of type [AATKitShakeScreenLogoAlignment]. Default value is left
     */
    internal var logoAlignment: AATKitShakeScreenLogoAlignment = AATKitShakeScreenLogoAlignment.Left

    /**
     * Show device type. Default value is true
     */
    var showDeviceType: Boolean = true

    /**
     * Aan email to share the debug information to.
     */
    var shareEmail: String? = null

    /**
     * Show debug logs toggle, default value is true.
     */
    var showDebugLogsToggle = true

    /**
     * Show device filtered rules toggle, default value is true.
     */
    var showDeviceFilteredRulesToggle = true

    /**
     * Show close button, default value is true.
     */
    var showCloseButton = true

    /**
     * Create an AATDebugScreenConfiguration instance.
     *
     * @param appLogo - App Logo, as [Drawable].
     * @param title - Shake debug screen title
     */
    constructor(
        appLogo: Drawable?,
        title: String?
    ) {
        this.appLogoDrawable = appLogo
        this.title = title
    }

    /**
     * Create an AATDebugScreenConfiguration instance.
     *
     * @param appLogo - App Logo, as the drawable resource reference.
     * @param title - Shake debug screen title
     */
    constructor(
        @DrawableRes appLogo: Int,
        title: String?
    ) {
        this.appLogoFromResources = appLogo
        this.title = title
    }
}