package com.intentsoftware.addapptr

import com.intentsoftware.addapptr.internal.module.ExchangeRateHelper

class PriceInfo (
    /**
     * Impression CPM price.
     */
    val price: Double,
    val currency: Currency,
    val precisionType: PrecisionType) {

    enum class Currency {
        UNKNOWN,
        EUR,
        USD
    }

    enum class PrecisionType {
        UNKNOWN,
        ESTIMATED,
        FLOOR_PRICE,
        PUBLISHER_PROVIDED,
        EXACT
    }

    override fun toString(): String {
        return "PriceInfo(price=$price, currency=$currency, precisionType=$precisionType)"
    }

    internal fun getPriceInEuro(): Double {
        return when (currency) {
            Currency.UNKNOWN -> price
            Currency.EUR -> price
            Currency.USD -> {
                val exchangeRate = ExchangeRateHelper.exchangeRateRules?.get(Currency.USD)?.takeIf { it > 0 } ?: 1.1

                return price / exchangeRate
            }
        }
    }
}