package com.intentsoftware.addapptr

import com.intentsoftware.addapptr.AATKit.setTargetingInfo

interface RewardedVideoPlacement : Placement {
    /**
     * Set the [placement listener][RewardedVideoPlacementListener] that will listen to ad loading and display events.
     */
    var listener: RewardedVideoPlacementListener?

    /**
     * Sets the [statistics listener][AATKit.StatisticsListener] that will be notified about placement reporting events, like counted adspace, request etc.
     */
    var statisticsListener: AATKit.StatisticsListener?

    /**
     * Sets the [impression listener][ImpressionListener] for the given placement.
     */
    var impressionListener: ImpressionListener?

    /**
     * Enables automatic reloading of placement.
     * When using this method, the placement will automatically reload once the current loaded ad has been shown.
     */
    fun startAutoReload()

    /**
     * Stop the automatic reloading of the placement.
     */
    fun stopAutoReload()

    /**
     * Requests placement reload. Works only if automatic reloading is disabled.
     *
     * @return True if call ends in causing a placement to reload, false otherwise.
     */
    fun reload(): Boolean

    /**
     * Returns true if there is an ad loaded for this placementId.
     */
    fun hasAd(): Boolean

    /**
     * Shows the fullscreen ad if ad is ready.
     * @return True if showing fullscreen was successful, false otherwise.
     */
    fun show(): Boolean

    /**
     * Sets the targeting information for the given placement. Information provided for placement overrides targeting information for application set by the [setTargetingInfo].
     */
    var targetingInfo: Map<String, List<String>>?

    /**
     * Sets the content targeting url for the application. This information will be used only if no placement-specific targeting is available.
     *
     * @see .setContentTargetingUrl
     */
    var contentTargetingUrl: String?

    /**
     * Checks if desired impression cap (set on AddApptr Dashboard) is reached for this placement.
     *
     * @return True if impression cap is reached for given placement, false otherwise.
     */
    fun isFrequencyCapReached(): Boolean
}
