package com.intentsoftware.addapptr

import com.intentsoftware.addapptr.internal.ConsentImplementation
import com.intentsoftware.addapptr.internal.ConsentTypeForReporting

/**
 * Allows to set the status of Non-IAB consent. Will also read the IAB consent string from SharedPreferences if available.
 */
class SimpleConsent
/**
 * Creates the [SimpleConsent] instance.
 *
 * @param nonIABConsent The status of GDPR consent for non-IAB partners.
 */(val nonIABConsent: NonIABConsent) : ConsentImplementation() {
    override val consentTypeForReporting: ConsentTypeForReporting
        get() {
            return if (consentStringVersion == ConsentStringVersion.CONSENT_VERSION_2) {
                ConsentTypeForReporting.SIMPLE_CONSENT_CMP
            } else {
                ConsentTypeForReporting.SIMPLE_CONSENT
            }
        }

    override fun getConsentForNetwork(network: AdNetwork): NonIABConsent {
        return nonIABConsent
    }

    override fun toString(): String {
        return "SimpleConsent{" +
                "nonIABConsent=" + nonIABConsent +
                ", consentStringVersion= " + consentStringVersion +
                ", consentString=" + consentString +
                "} " + super.toString()
    }
}