package com.intentsoftware.addapptr

/**
 * Placement used for obtaining banner ads.
 */
@Suppress("unused")
interface InfeedBannerPlacement : Placement {

    /**
     * Set the [placement listener][InfeedBannerPlacementListener] that will listen to ad loading and display events.
     */
    var listener: InfeedBannerPlacementListener?

    /**
     * Sets the [statistics listener][AATKit.StatisticsListener] that will be notified about placement reporting events, like counted adspace, request etc.
     */
    var statisticsListener: AATKit.StatisticsListener?

    /**
     * Sets the [impression listener][ImpressionListener] for the given placement.
     */
    var impressionListener: ImpressionListener?

    /**
     * Setting for Google collapsible banners. Default is null, meaning disabled support for collapsible banners.
     */
    var collapsibleBannerOptions: CollapsibleBannerOptions?

    /**
     * Requests a new banner ad.
     * @param request [BannerRequest] instance. Can not be null.
     * @param listener [BannerRequestCompletionListener] instance that will be called when the request finishes. Can not be null.
     */
    fun requestAd(request: BannerRequest, listener: BannerRequestCompletionListener?)

    /**
     * Cancels the given banner request.
     * @param request Request that should be canceled.
     */
    fun cancel(request: BannerRequest)

    /**
     * Counts the adspace for statistics. Can only be called if manual adspace counting is used.
     * @see BannerConfiguration.isManualAdSpaceCounting
     */
    fun countAdSpace()

}