import { IonicNativePlugin } from '@ionic-native/core';
/**
 * @name A A T Kit Ionic
 * @description
 * This plugin does something
 *
 * @usage
 * ```typescript
 * import { AATKitIonic } from '@ionic-native/aat-kit-ionic';
 *
 *
 * constructor(private aATKitIonic: AATKitIonic) { }
 *
 * ...
 *
 *
 * this.aATKitIonic.functionName('Hello', 123)
 *   .then((res: any) => console.log(res))
 *   .catch((error: any) => console.error(error));
 *
 * ```
 */
export declare class AATKitIonic extends IonicNativePlugin {
    /**
     * This function does something
     * @param arg1 {string} Some param to configure something
     * @param arg2 {number} Another param to configure something
     * @return {Promise<any>} Returns a promise that resolves when something happens
     */
    setDebugEnabled(enabled: boolean): Promise<any>;
    setDebugShakeEnabled(enabled: boolean): Promise<any>;
    initWithConfiguration(configuration: any): Promise<any>;
    createPlacement(placementName: string, size: string): Promise<any>;
    addPlacementToView(placementName: string): Promise<any>;
    removePlacementFromView(placementName: string): Promise<any>;
    setPlacementAlignment(placementName: string, alignment: string): Promise<any>;
    setPlacementAlignmentWithOffset(placementName: string, alignment: string, x: number, y: number): Promise<any>;
    setPlacementPosition(placementName: string, x: number, y: number): Promise<any>;
    setPlacementContentGravity(placementName: string, gravity: string): Promise<any>;
    startPlacementAutoReload(placementName: string): Promise<any>;
    stopPlacementAutoReload(placementName: string): Promise<any>;
    showPlacement(placementName: string, callback: any): Promise<any>;
    showConsentDialogIfNeeded(): Promise<any>;
    editConsent(): Promise<any>;
    reloadConsent(): Promise<any>;
}
